#include <algorithm>
#include <iostream>
#include <vector>

using ll = long long;

int main() {
    int n;
    std::cin >> n;
    std::vector<std::pair<int, std::pair<bool, int>>> exams(
        2 * n);  // day, {is last day, exam index}
    std::vector<int> c(n);
    std::vector<bool> passed(n, false);
    for (int i = 0; i < n; ++i) {
        int a, b, cc;
        std::cin >> a >> b >> cc;
        c[i] = cc;
        exams[2 * i].second.first = true;
        exams[2 * i + 1].second.first = false;
        exams[2 * i].first = a - cc;
        exams[2 * i + 1].first = b;
        exams[2 * i].second.second = exams[2 * i + 1].second.second = i;
    }
    std::sort(exams.begin(), exams.end());
    int last_day = -1e9;  // last used day, without preparation
    for (auto x : exams) {
        if (x.second.first == true && !passed[x.second.second]) {
            if (x.first > last_day) {
                passed[x.second.second] = true;
                last_day = x.first + c[x.second.second];
            }
        } else if (x.second.first == false && !passed[x.second.second]) {
            if (x.first - c[x.second.second] > last_day) {
                passed[x.second.second] = true;
                last_day = x.first;
            }
        }
    }

    for (auto x : passed) {
        if (x == false) {
            last_day = -1;
            break;
        }
    }

    std::cout << last_day << "\n";
}